<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Check Functions File</h1>";

echo "<h2>1. Functions File Path</h2>";
$functionsPath = __DIR__ . '/includes/functions.php';
echo "<p><strong>Path:</strong> " . $functionsPath . "</p>";

if (file_exists($functionsPath)) {
    echo "<p style='color: green;'>✅ Functions file exists</p>";
    
    echo "<h2>2. File Size and Modified Date</h2>";
    echo "<p><strong>Size:</strong> " . number_format(filesize($functionsPath)) . " bytes</p>";
    echo "<p><strong>Last Modified:</strong> " . date('Y-m-d H:i:s', filemtime($functionsPath)) . "</p>";
    
    echo "<h2>3. Try to Load Config and Functions</h2>";
    try {
        require_once __DIR__ . '/config/config.php';
        echo "<p style='color: green;'>✅ Config loaded</p>";
        
        require_once $functionsPath;
        echo "<p style='color: green;'>✅ Functions loaded</p>";
    } catch (Exception $e) {
        echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
    }
    
    echo "<h2>4. Check Required Functions</h2>";
    $requiredFunctions = [
        'isLoggedIn',
        'isAdmin',
        'requireLogin',
        'requireAdmin',
        'formatPrice',
        'usdToIrr',
        'sanitize',
        'validateMobile',
        'validateEmail',
        'loginUser',
        'createUser',
        'getUserByMobile',
        'createOrder',
        'getOrderById',
        'getUserOrders',
        'getAllOrders',
        'updateOrderStatus',
        'updateOrderWithESIM'
    ];
    
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>Function</th><th>Exists?</th></tr>";
    
    foreach ($requiredFunctions as $func) {
        $exists = function_exists($func);
        $color = $exists ? 'green' : 'red';
        
        echo "<tr>";
        echo "<td><strong>" . $func . "()</strong></td>";
        echo "<td style='color: " . $color . ";'>" . ($exists ? '✅ Yes' : '❌ No') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<h2>5. Search for updateOrderStatus in File</h2>";
    $content = file_get_contents($functionsPath);
    if (strpos($content, 'function updateOrderStatus') !== false) {
        echo "<p style='color: green;'>✅ Function 'updateOrderStatus' found in file</p>";
        
        // Show the function
        preg_match('/function updateOrderStatus.*?\n\}/s', $content, $matches);
        if (!empty($matches)) {
            echo "<p><strong>Function Code:</strong></p>";
            echo "<pre>" . htmlspecialchars($matches[0]) . "</pre>";
        }
    } else {
        echo "<p style='color: red;'>❌ Function 'updateOrderStatus' NOT found in file</p>";
        echo "<p><strong>This means the functions.php file on the server is outdated!</strong></p>";
    }
    
    echo "<h2>6. File Content Preview (First 100 lines)</h2>";
    $lines = file($functionsPath);
    echo "<pre>";
    for ($i = 0; $i < min(100, count($lines)); $i++) {
        echo ($i + 1) . ": " . htmlspecialchars($lines[$i]);
    }
    echo "</pre>";
    
} else {
    echo "<p style='color: red;'>❌ Functions file does NOT exist</p>";
}

?>

<style>
body {
    font-family: Tahoma, Arial, sans-serif;
    padding: 20px;
    direction: rtl;
}
h1, h2 {
    color: #333;
    border-bottom: 2px solid #667eea;
    padding-bottom: 10px;
}
table {
    margin: 20px 0;
}
th {
    background: #667eea;
    color: white;
    text-align: right;
}
td {
    text-align: right;
}
pre {
    background: #f5f5f5;
    padding: 15px;
    border-radius: 5px;
    overflow-x: auto;
    direction: ltr;
    text-align: left;
    max-height: 500px;
    overflow-y: auto;
}
</style>

